 ; Ŀ
 ;   Tb - switch tag blocks for ones with breaks for oversized text.       
 ;   Also contains Twa - set all attributes in a block to 0.9 width,       
 ;   and Bt, replace all chopped blocks with the unchopped version.        
 ;   Copyright 2006 by Rocket Software Ltd.                                
 ;   Why are there no chalk lines which make numbers?                      
 ; 

 ; Ŀ
 ;   Twa - set all attributes in selected blocks to the same width.        
 ;   Calls Twa.                                                            
 ; 
 (DEFUN C:TWA (/ ss num enam)
  (setq ss (ssget (list (cons 66 1) (cons 0 "insert"))))
  (setq num 0)
  (while (and ss (setq enam (ssname ss num)))
         (setq num (1+ num))
         (twa enam 0.9))
 (princ))
 ; Ŀ
 ;   C:Twa end.                                                            
 ; 

 ; Ŀ
 ;   Atlist - suck attribute values from a block into a list.              
 ; 
 (DEFUN ATLIST (enam / entt tagg taglst)
  (while (and (setq entt (entget (setq enam (entnext enam))))
              (/= (cdr (assoc 0 entt)) "SEQEND"))
         (setq tagg (cdr (assoc 1 entt)))
         (setq taglst (append taglst (list tagg))))
 taglst)
 ; Ŀ
 ;   Atlist end.                                                           
 ; 

 ; Ŀ
 ;   Mezhur - see if either attribute in a block is too wide.              
 ; 
 (DEFUN MEZHUR (enam top base / withok blscal entt)
  (setq withok 0)
  (setq blscal (abs (cdr (assoc 41 (entget enam)))))
  (setq entt (entget (setq enam (entnext enam))))
  (if (> (wits entt) (* top blscal))
      (setq withok (+ withok 1)))
  (setq entt (entget (setq enam (entnext enam))))
  (if (> (wits entt) (* base blscal))
      (setq withok (+ withok 2)))
 withok)
 ; Ŀ
 ;   Mezhur end.                                                           
 ; 

 ; Ŀ
 ;   Subroutine Rebl - replace a block with another.                       
 ;   Arguments: Enam, the ename of the insert to replace.                  
 ;              Gnunam, the new block name.                                
 ;   Calls atlist.                                                         
 ; 
 (DEFUN REBL (enam gnunam / entt pa xscl yscl rota laya lyta cola attlst esav
                                                                         tag)
  (setq entt (entget enam))
 ; Ŀ
 ;   Get the block insertion data and the attribute value list.            
 ; 
  (setq pa (cdr (assoc 10 entt)))
  (setq xscl (abs (cdr (assoc 41 entt))))   ; don't allow
  (setq yscl (abs (cdr (assoc 42 entt))))   ; mirrored tags
  (setq rota (* (/ 180 pi) (cdr (assoc 50 entt))))
  (setq laya (cdr (assoc 8 entt)))
  (setq lyta (cdr (assoc 6 entt)))
  (if (null lyta) (setq lyta "Bylayer"))
  (setq cola (cdr (assoc 62 entt)))
  (if (null cola) (setq cola "Bylayer"))
  (if (= cola 0) (setq cola "Byblock"))
  (setq attlst (atlist enam))
 ; Ŀ
 ;   Erase the original block.                                             
 ; 
  (entdel enam)
 ; Ŀ
 ;   Insert the new block.                                                 
 ; 
  (command ".insert" gnunam pa xscl yscl rota)
 ; Ŀ
 ;   Fill the attributes with spaces - not all attributes are prompted     
 ;   for on insertion, so it is safer to put them in directly.             
 ; 
  (while (= 1 (getvar "cmdactive")) (command "")) 
  (setq esav (setq enam (entlast)))
  (while (and (/= "SEQEND" (cdr (assoc 0 (setq entt (entget 
                                               (setq enam (entnext enam)))))))
              (setq tag (car attlst)))
         (setq attlst (cdr attlst))
         (entmod (subst (cons 1 tag) (assoc 1 entt) entt)))
  (entupd esav)
 ; Ŀ
 ;   Make it match the colour, layer, and linetype of the original.        
 ; 
  (command "change" (entlast) "" "p" "colour" cola
                                     "layer" laya
                                     "ltype" lyta "")
 (princ))
 ; Ŀ
 ;   Rebl end.                                                             
 ; 

 ; Ŀ
 ;   Subroutine Sebe - check and possibly swap a tag block.                
 ;   Arguments: Enam, a block entity name.                                 
 ;              Blnam, the block name.                                     
 ;              Basnam, the base part of the block name (i.e. no "-n").    
 ;              Atwid, the maximum allowed attribute width.                
 ; 
 (DEFUN SEBE (enam blnam basnam atwid / blsuff gnunam)
 ; Ŀ
 ;   Call Twa to set the attributes back to the correct width.             
 ; 
  (twa enam 0.9)
 ; Ŀ
 ;   Call Mezhur to see if either string is too long for the space it      
 ;   occupies in the block.                                                
 ;   Mezhur returns 1 if the top string is too wide, 2 if the bottom       
 ;   one is, and 3 if both are.  (Else 0.)                                 
 ; 
  (setq blsuff (mezhur enam atwid atwid))
 ; Ŀ
 ;   Make the correct block name.                                          
 ; 
  (if (null (zerop blsuff))
      (setq gnunam (strcat basnam "-" (itoa blsuff)))
      (setq gnunam basnam))
 ; Ŀ
 ;   If the block isn't the correct one, replace it.                       
 ; 
  (if (/= blnam gnunam)
      (rebl enam gnunam))
 (princ))
 ; Ŀ
 ;   Sebe end.                                                             
 ; 

 ; Ŀ
 ;   Subroutine Twa - set all attributes in a block to the same width.     
 ;   Arguments: Enam, a block ename.                                       
 ;              Cwid, the desired width scale factor.                      
 ;   Calls nothing, returns nothing.                                       
 ; 
 (DEFUN TWA (enam cwid / esav entt widsc asoc41 moda)
  (setq esav enam)
 ; Ŀ
 ;   Repeat until come to the block end marker.                            
 ; 
  (while (/= (cdr (assoc 0 (setq entt (entget (setq enam (entnext enam))))))
                                                                   "SEQEND")
 ; Ŀ
 ;   Get the attribute width scale factor.                                 
 ; 
         (setq widsc (cdr (setq asoc41 (assoc 41 entt))))
 ; Ŀ
 ;   Compare the actual and desired widths.                                
 ;   If the actual width is not equal to the ideal, then make it so.       
 ; 
         (if (/= widsc cwid)
             (progn
                  (entmod (subst (cons 41 cwid) asoc41 entt))
                  (setq moda t))))
 ; Ŀ
 ;   If the modified flag Moda is set then regen the insert.               
 ; 
  (if moda (entupd esav))
 (princ))
 ; Ŀ
 ;   Twa end.                                                              
 ; 

 ; Ŀ
 ;   Subroutine Wits - find the width of an attribute.                     
 ;   Takes one argument: the attribute entity data list.  Returns a width. 
 ; 
 (DEFUN WITS (entt / tblist cc dd bwidth)
  (setq tblist (textbox entt))
  (setq cc (car tblist))                    ; ll offset from 10 of text
  (setq dd (cadr tblist))                   ; ur offset from 10 of text
  (setq bwidth (abs (- (car dd) (car cc)))))
 ; Ŀ
 ;   Wits end.                                                             
 ; 

 ; Ŀ
 ;   Bt - replace chopped tag blocks with whole ones.                      
 ; 
 (DEFUN C:BT (/ attd snapp osmo *error* taglst ss num enam blnam basnam sub)
  (setvar "cmdecho" 0)
  (command "undo" "be")
  (setq attd (getvar "attdia"))
  (setvar "attdia" 0)
  (setq snapp (getvar "snapmode"))
  (setvar "snapmode" 0)
  (setq osmo (getvar "osmode"))
  (setvar "osmode" 0)
 ; Ŀ
 ;   Locally redefine the error handler.                                   
 ; 
  (DEFUN *error* (shk)
   (setvar "attdia" attd)
   (if osmo (setvar "osmode" osmo))
   (setvar "snapmode" snapp)
   (command "undo" "end")
   (if shk (write-line shk))
  (princ))
 ; Ŀ
 ;   Make a list of tag names.                                             
 ; 
  (setq taglst '("dettag"            "inst-tag"
                 "instr-discr-pri"   "instr-share-pri"
                 "instr-soft-pri"    "instr-plc-pri"
                 "instr-discr-field" "instr-share-field"
                 "instr-soft-field"  "instr-plc-field"
                 "instr-discr-aux"   "instr-share-aux"
                 "instr-soft-aux"    "instr-plc-aux"
                 "instr-discr-hid"   "instr-share-hid"
                 "instr-soft-hid"    "instr-plc-hid"
                 "patchboard-pt"))
 ; Ŀ
 ;   Get a selection set of tag blocks.                                    
 ; 
  (prompt "Select Instrument Tags or <Return> for All:")
  (if (null (setq ss (ssget (list (cons 2 "dettag*,inst*,patchboard-pt*")))))
      (setq ss (ssget "x" (list (cons 2 "dettag*,inst*,patchboard-pt*")))))
 ; Ŀ
 ;   Check each block for possible replacement.                            
 ; 
  (setq num 0)
  (while (and ss (setq enam (ssname ss num)))
         (setq num (1+ num))
         (setq blnam (cdr (assoc 2 (entget enam))))
 ; Ŀ
 ;   Extract the base block name.                                          
 ; 
         (if (member (substr blnam (1- (strlen blnam))) '("-1" "-2" "-3"))
             (setq basnam (substr blnam 1 (- (strlen blnam) 2)))
             (setq basnam blnam))
 ; Ŀ
 ;   See if there is a matching attribute width list entry.                
 ; 
         (if (and (setq sub (member (strcase basnam t) taglst))
                  (/= basnam blnam))
             (rebl enam basnam)))
 ; Ŀ
 ;   Clean up and end.                                                     
 ; 
  (*error* nil)
 (princ))
 ; Ŀ
 ;   C:BT end.                                                             
 ; 

 ; Ŀ
 ;   TB.                                                                   
 ; 
 (DEFUN C:TB (/ attd snapp osmo *error* taglst ss num enam blnam basnam sub)
  (setvar "cmdecho" 0)
  (command "undo" "be")
  (setq attd (getvar "attdia"))
  (setvar "attdia" 0)
  (setq snapp (getvar "snapmode"))
  (setvar "snapmode" 0)
  (setq osmo (getvar "osmode"))
  (setvar "osmode" 0)
 ; Ŀ
 ;   Locally redefine the error handler.                                   
 ; 
  (DEFUN *error* (shk)
   (setvar "attdia" attd)
   (if osmo (setvar "osmode" osmo))
   (setvar "snapmode" snapp)
   (command "undo" "end")
   (if shk (write-line shk))
  (princ))
 ; Ŀ
 ;   Make a list of tag names and allowable attribute widths.              
 ; 
  (setq taglst '(("dettag" 8)            ("inst-tag" 6.5)
                 ("instr-discr-pri" 8)   ("instr-share-pri" 8)
                 ("instr-soft-pri" 8)    ("instr-plc-pri" 3)
                 ("instr-discr-field" 8) ("instr-share-field" 8)
                 ("instr-soft-field" 8)  ("instr-plc-field" 3)
                 ("instr-discr-aux" 8)   ("instr-share-aux" 8)
                 ("instr-soft-aux" 8)    ("instr-plc-aux" 3)
                 ("instr-discr-hid" 8)   ("instr-share-hid" 8)
                 ("instr-soft-hid" 8)    ("instr-plc-hid" 3)
                 ("patchboard-pt" 3)))
 ; Ŀ
 ;   Get a selection set of tag blocks.                                    
 ; 
  (prompt "Select Instrument Tags or <Return> for All:")
  (if (null (setq ss (ssget (list (cons 2 "dettag*,inst*,patchboard-pt*")))))
      (setq ss (ssget "x" (list (cons 2 "dettag*,inst*,patchboard-pt*")))))
 ; Ŀ
 ;   Check each block for possible replacement.                            
 ; 
  (setq num 0)
  (while (and ss (setq enam (ssname ss num)))
         (setq num (1+ num))
         (setq blnam (cdr (assoc 2 (entget enam))))
 ; Ŀ
 ;   Extract the base block name.                                          
 ; 
         (if (member (substr blnam (1- (strlen blnam))) '("-1" "-2" "-3"))
             (setq basnam (substr blnam 1 (- (strlen blnam) 2)))
             (setq basnam blnam))
 ; Ŀ
 ;   See if there is a matching attribute width list entry.                
 ; 
         (if (setq sub (assoc (strcase basnam t) taglst))
             (sebe enam blnam basnam (cadr sub))))
 ; Ŀ
 ;   Clean up and end.                                                     
 ; 
  (*error* nil)
 (princ))